﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class SpecialtyMap
    {
        public static async Task<IQueryable<Specialty>> MapSpecialties(List<ppms_taxonomy> ppmsSpecialties, string mapRelatedType, PpmsContext context)
        {
            var specialties = new List<Specialty> {};
            foreach (var ppmsSpecialty in ppmsSpecialties)
            {
                //Populate the Specialty Details
                var specialty = new Specialty
                {
                    Name = ppmsSpecialty.ppms_codedspecialty,
                    Grouping = ppmsSpecialty.ppms_grouping,
                    Classification = ppmsSpecialty.ppms_classification,
                    Specialization = ppmsSpecialty.ppms_specialization,
                    SpecialtyCode = ppmsSpecialty.ppms_SpecialtyCode,
                    SpecialtyDescription = ppmsSpecialty.ppms_specialtydescription
                };

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";
                if (mapRelatedType.Contains("?$expand=ProviderSpecialties"))
                    mapRelatedType = "ProviderSpecialties";

                //Map Related entity section
                switch (mapRelatedType)
                {
                    case "ProviderServices":
                        //Lookup and Map the Provider Services
                        var ppmsProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_specialty.Id == ppmsSpecialty.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        specialty.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;
                    case "ProviderSpecialties":
                        //Lookup and Map the Provider Specialties
                        var ppmsProviderSpecialties =
                            context.ppms_providertaxonomySet.Where(i => i.ppms_TaxonomyId.Id == ppmsSpecialty.Id);
                        var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                        specialty.ProviderSpecialties =
                            await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialtiesList, "None", context);
                        break;
                    

                    default:
                        break;
                }



                specialties.Add(specialty);
            }
            return specialties.AsQueryable();            
        }
    }
}